/*
 * Decompiled with CFR 0.152.
 */
package moe.score.pishockzap.shockcalculation;

import java.util.Objects;
import java.util.logging.Logger;
import lombok.NonNull;
import moe.score.pishockzap.config.PishockZapConfig;
import moe.score.pishockzap.config.ShockDistribution;
import moe.score.pishockzap.pishockapi.PiShockApi;
import moe.score.pishockzap.shockcalculation.CalculatedShock;
import moe.score.pishockzap.shockcalculation.ShockQueue;

public class ZapController {
    private final Logger logger = Logger.getLogger("PiShock-Zap");
    @NonNull
    private volatile PiShockApi api;
    private final Thread thread = new Thread(this::run);
    @NonNull
    private final PishockZapConfig config;
    @NonNull
    private final ShockQueue shockQueue;

    public ZapController(@NonNull PiShockApi api, @NonNull PishockZapConfig config) {
        Objects.requireNonNull(api, "api is marked non-null but is null");
        Objects.requireNonNull(config, "config is marked non-null but is null");
        this.api = api;
        this.config = config;
        this.shockQueue = new ShockQueue(config);
    }

    public void start() {
        this.thread.setDaemon(true);
        this.thread.start();
    }

    public void stop() {
        this.thread.interrupt();
    }

    public void setApi(@NonNull PiShockApi api) {
        Objects.requireNonNull(api, "api is marked non-null but is null");
        this.api.close();
        this.api = api;
    }

    private void run() {
        try {
            while (true) {
                CalculatedShock shockData = this.shockQueue.takeAndMergeShocks();
                this.logger.info("Performing shock: " + String.valueOf(shockData));
                this.api.performOp(shockData.distribution(), shockData.type(), shockData.intensity(), shockData.duration());
                Thread.sleep((long)((shockData.duration() + this.config.getDebounceTime()) * 1000.0f));
            }
        }
        catch (InterruptedException e) {
            return;
        }
    }

    public void queueShock(@NonNull ShockDistribution distribution, boolean isDeath, float damageEquivalent) {
        Objects.requireNonNull(distribution, "distribution is marked non-null but is null");
        this.logger.info("Queueing shock: " + String.valueOf((Object)distribution) + ", " + isDeath + ", " + damageEquivalent);
        this.shockQueue.queueShock(distribution, isDeath, damageEquivalent);
    }

    @NonNull
    public PiShockApi getApi() {
        return this.api;
    }
}

